// Craig S. Kaplan
// A complicated example of hierarchical modelling --
// draw a street of houses with a night sky and some
// stars.

import processing.pdf.*;

void doorknob()
{
  fill( 140 );
  ellipse( 0, 0, 100, 100 );
  fill( 80 );
  ellipse( 0, 0, 50, 50 );
}

void door()
{
  fill( #553A03 );
  rect( -25, -50, 50, 100 );
  fill( #714D05 );
  rect( -20, -45, 40, 40 );
  rect( -20, 5, 40, 40 );

  pushMatrix();
  translate( 20, 0 );
  scale( 0.1 );
  doorknob();
  popMatrix();
}

void window()
{
  fill( #553A03 );
  rect( -25, -30, 50, 60 );
  fill( #FFF97E );
  rect( -20, -25, 40, 50 );
  fill( 100 );
  rect( -20, -25, 40, 30 );
  line( 0, 5, 0, 15 );
  fill( 0 );
  ellipse( 0, 15, 4, 4 );
}

void house()
{
  // The body and roof of the house.
  fill( #D6CEA0 );
  rect( -100, -150, 200, 150 );
  fill( #676558 );
  triangle( 0, -200, -120, -150, 120, -150 );

  // Add in the two doors. Note that one door
  // is the mirror image of the other one, hence
  // the "scale(-1,1)".
  pushMatrix();
  scale( 0.5 );
  translate( -25, -50 );
  door();
  popMatrix();
  pushMatrix();
  scale( 0.5 );
  scale( -1, 1 );
  translate( -25, -50 );
  door();
  popMatrix();

  // Draw a row of three windows.
  pushMatrix();
  translate( -60, -100 );
  for ( int idx = 0; idx < 3; ++idx ) {
    window();
    translate( 60, 0 );
  }
  popMatrix();
}

void star()
{
  fill( 255 );
  noStroke();
  beginShape();
  // A sneaky trick for drawing a five-pointed star.
  for( int idx = 0; idx < 5; ++idx ) {
    vertex( 50*cos(TWO_PI*0.4*idx), 50*sin(TWO_PI*0.4*idx) );
  }
  endShape();
  stroke( 0 );
}

void setup()
{
  size( 800, 600 );
  
  beginRecord( PDF, "output.pdf" );
  
  // Set the initial colour to a night sky.
  background( #1A1548 );
  stroke( 0 );
  strokeWeight( 1.0 );

  // Draw a bunch of random stars.
  for( int idx = 0; idx < 200; ++idx ) {
    pushMatrix();
    translate( random( width ), random( 400 ) );
    rotate( random( TWO_PI ) );
    scale( random( 0.01, 0.1 ) );
    star();
    popMatrix();
  }

  pushMatrix();
  translate( 0, 400 );
  scale( 0.3, 0.3 );

  // Draw a row of houses.
  for ( int idx = 0; idx < 11; ++idx ) {
    house();
    translate( 270, 0 );
  }
  popMatrix();
  
  // Draw the street.
  fill( 180 );
  rect( 0, 400, width, height-400 );
  
  endRecord();
}